#!/bin/bash

# Docker-Compose Variables
# ========================

# Docker Bridge Network Settings
# ------------------------------
export NETWORK_SUBNET=10.111.1.0/24
export NETWORK_GATEWAY=10.111.1.254
export MQTT_BROKER_IPV4=10.111.1.20


# Manager Service
# ---------------

# Certificate settings
# ********************

# Hostname and IP address are added as DNS and IP [alt_names] to ssl certificats for Webfrontend, Mqtt-Broker and OPCUA-Service.
export MANAGER_HOSTNAME=$(hostname)
export IP_ADDRESS=192.168.1.10

# Core Service
# ------------
# Address to connect Gateways with Cloud.
# Should be $MANAGER_HOSTNAME or $IP_ADDRESS
export CLOUD_ADDRESS=$IP_ADDRESS
export SELF_UPDATE_ENVIRONMENT_DIR=$(pwd)