#!/bin/bash

set -e

IMAGE_NAME=$(ls | grep cloud_self_update)

# Load image
docker load -i $IMAGE_NAME
IMAGE_ID=$(docker image ls | grep cloud_self_update | awk '{print $3}')
echo IMAGE_ID=$IMAGE_ID

if ! grep -Fq "# autogenerated cloud_first_start.sh" ./cloud_environment.sh
then
    echo ""  >> ./cloud_environment.sh
    echo "# autogenerated cloud_first_start.sh" >> ./cloud_environment.sh
    echo "# **********************************" >> ./cloud_environment.sh
fi

# Add SELF_UPDATE_ENVIRONMENT_DIR env variable to ./cloud_environment.sh if not exists
if ! grep -Fq "export SELF_UPDATE_ENVIRONMENT_DIR=" ./cloud_environment.sh
then
    echo "export SELF_UPDATE_ENVIRONMENT_DIR=$(pwd)" >> ./cloud_environment.sh
fi

# Create and run container
docker run --rm -v /var/run/docker.sock:/var/run/docker.sock -v $(pwd)/laepple_wpm:/root/laepple_wpm laepple_wpm_cloud_self_update:latest bash /root/cloud-extract-deploy-v2.sh

